/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class LengthMarkedBufferedInputStream
extends FilterInputStream {
    private static int INITIAL_BUFFER_SIZE = 512;
    private InputStream in;
    private byte[] buf;
    private int count;
    private int marked_length;
    private int marked_index;

    public LengthMarkedBufferedInputStream(InputStream in) {
        super(in);
        this.in = in;
        this.buf = new byte[INITIAL_BUFFER_SIZE];
        this.count = 0;
        this.marked_length = -1;
        this.marked_index = -1;
    }

    private void ensureCapacity(int new_size) {
        int old_size = this.buf.length;
        if (new_size > old_size) {
            int cap = old_size * 3 / 2 + 1;
            if (cap < new_size) {
                cap = new_size;
            }
            byte[] old_buf = this.buf;
            this.buf = new byte[cap];
            System.arraycopy(old_buf, 0, this.buf, 0, this.count - 0);
        }
    }

    private void handleEndReached() {
        System.arraycopy(this.buf, this.marked_index, this.buf, 0, this.count - this.marked_length);
        this.count -= this.marked_length;
        this.marked_length = -1;
        this.marked_index = -1;
    }

    public synchronized int read() throws IOException {
        if (this.marked_index == -1) {
            throw new IOException("No mark has been read yet.");
        }
        if (this.marked_index >= this.marked_length) {
            String debug_msg = "Read over end of length marked buffer.  ";
            debug_msg = debug_msg + "(marked_index=" + this.marked_index;
            debug_msg = debug_msg + ",marked_length=" + this.marked_length + ")";
            debug_msg = debug_msg + ")";
            throw new IOException(debug_msg);
        }
        int n = this.buf[this.marked_index++] & 0xFF;
        if (this.marked_index >= this.marked_length) {
            this.handleEndReached();
        }
        return n;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.marked_index == -1) {
            throw new IOException("No mark has been read yet.");
        }
        int read_upto = this.marked_index + len;
        if (read_upto > this.marked_length) {
            String debug_msg = "Read over end of length marked buffer.  ";
            debug_msg = debug_msg + "(marked_index=" + this.marked_index;
            debug_msg = debug_msg + ",len=" + len;
            debug_msg = debug_msg + ",marked_length=" + this.marked_length + ")";
            throw new IOException(debug_msg);
        }
        System.arraycopy(this.buf, this.marked_index, b, off, len);
        this.marked_index = read_upto;
        if (this.marked_index >= this.marked_length) {
            this.handleEndReached();
        }
        return len;
    }

    public synchronized int available() throws IOException {
        if (this.marked_length >= 0) {
            return this.marked_length - this.marked_index;
        }
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized boolean pollForCommand(int max_size) throws IOException {
        if (this.marked_length == -1) {
            int available = this.in.available();
            if (this.count > 0 || available > 0) {
                int length_marker;
                if (this.count + available > max_size) {
                    throw new IOException("Marked length is greater than max size ( " + (this.count + available) + " > " + max_size + " )");
                }
                this.ensureCapacity(this.count + available);
                int read_in = this.in.read(this.buf, this.count, available);
                if (read_in == -1) {
                    throw new EOFException();
                }
                this.count += read_in;
                if (this.count >= 4 && this.count >= (length_marker = ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0)) + 4) {
                    this.marked_length = length_marker + 4;
                    this.marked_index = 4;
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized void blockForCommand() throws IOException {
        while (true) {
            int read_in;
            int length_marker;
            if (this.count >= 4 && this.count >= (length_marker = ((this.buf[0] & 0xFF) << 24) + ((this.buf[1] & 0xFF) << 16) + ((this.buf[2] & 0xFF) << 8) + ((this.buf[3] & 0xFF) << 0)) + 4) {
                this.marked_length = length_marker + 4;
                this.marked_index = 4;
                return;
            }
            if (this.count >= this.buf.length) {
                this.ensureCapacity(this.count + INITIAL_BUFFER_SIZE);
            }
            if ((read_in = this.in.read(this.buf, this.count, this.buf.length - this.count)) == -1) {
                throw new EOFException();
            }
            this.count += read_in;
        }
    }
}

